<?php include PATH_VIEW.'/layout/header.tpl'; ?>
<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">
		
		<div class="row">

			<div class="col-md-8">
				
				<section id="column1" class="mb-4">

					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW.'/layout/breadcrumb.tpl' ?>
					</section>
					
					<article itemscope itemtype="https://schema.org/NewsArticle">
					
						<h1 itemprop="headline" class="title-post"><?php echo $item->title; ?></h1>
						
						<p itemprop="description" class="mb-0"><?php echo $item->description; ?></p>

						<div class="d-flex justify-content-between align-items-center mb-3">
							<div class="mt-3">
								<span itemprop="datePublished" content="<?php echo $item->date_post ?>"><?php echo FormatDate($setting->format_date, $item->date_post); ?><span>
							</div>
							<div class="mt-3" id="shareBS" data-url="<?php echo $og_url; ?>" data-title="<?php echo $og_title; ?>"></div>
						</div>
					
						<meta itemprop="image" content="<?php echo $og_image; ?>" />
					</article>
				
					<?php if($itemList) { ?>
						<section class="row mt-4 image-grid">
							<?php foreach($itemList as $i){ ?>
								<div class="col-md-3 col-sm-4 col-6 mb-3">
									<div class="card post1-card h-100  text-bg-dark">
										<a class="link-post" href="<?php echo PATH_SYSTEM."public/album/".$i->album_id.'/'.$i->photo; ?>#" aria-label="photo <?php echo $i->id; ?>"></a>
										<img loading="lazy" src="<?php echo PATH_SYSTEM."public/album/".$i->album_id.'/'.$i->photo; ?>" class="card-img" alt="thumbnail <?php echo $i->id; ?>">
										<span class="button"><i class="fas fa-image"></i></span>
									</div>
								</div>
							<?php } ?>
						</section>
					<?php }else{ ?>
						<div class="alert alert-danger" role="alert">
							<?php echo $_LANG['empty'] ?>
						</div>
					<?php } ?>

				</section>
			</div>

		
			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php 
							// widgets column 2
							include PATH_VIEW.'/layout/search.tpl';
							include PATH_VIEW.'/layout/category.tpl';

							$widgetPos = 4;
							include PATH_VIEW.'/layout/widget.tpl';
						?>
		
					</section>
				</aside>
			</div>

		</div>
		
	</div>

	<!-- modal lightbox -->
	<div class="modal lightbox-modal" id="lightbox-modal" tabindex="-1">
		<div class="modal-dialog modal-lg modal-dialog-centered">
			<div class="modal-content">
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fas fa-close"></i></button>
				<div class="modal-body">
					<div class="container-fluid p-0"></div>
				</div>
			</div>
		</div>
	</div>

</div>

<?php include PATH_VIEW.'/layout/footer.tpl'; ?>